/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.hsc.websm.cec.CECInfo;
import com.ibm.hsc.websm.lpar.LPARInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class LsHwRes {
    public static final int MANAGED_SYSTEM = 0;
    public static final int PARTITION_NAME = 1;
    public static final int RESOURCE_TYPE = 2;
    public static final int DETAIL = 3;
    public static final String CPU = "cpu";
    public static final String MEM = "mem";
    public static final String SLOT = "slot";
    public static final String GET_DLPAR_CPU_INFO = "getDLPARCPUInfo";
    public static final String LPAR_SLOT_ID = "LPARSlotId";
    public static final String ALLOCATED_CPU = "allocatedCPU";
    public static final String MINIMUM_CPU = "minimumCPU";
    public static final String MAXIMUM_CPU = "maximumCPU";
    public static final String RUNNING_LPAR_MASK = "runningLPARMask";
    public static final String STOPPED_CPU = "stoppedCPU";
    public static final String GET_DLPAR_MEM_INFO = "getDLPARMemInfo";
    public static final String ALLOCATED_MEM = "allocatedMem";
    public static final String MINIMUM_MEM = "minimumMem";
    public static final String MAXIMUM_MEM = "maximumMem";
    public static final String NO_FORMAT_DELIMITER = ";";
    private String _managedSystem = null;
    private String _partitionName = "";
    private String _resourceType = null;
    private boolean _detail = false;
    private CIMObjectPath _managedSystemCOP = null;
    private CIMObjectPath _partitionCOP = null;
    private UnsignedInt8 _partitionSlot = new UnsignedInt8(0);
    private String hostName = null;

    public LsHwRes() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public boolean validateArguments(String[] stringArray) {
        CIMObjectPath cIMObjectPath = null;
        Enumeration enumeration = null;
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        String string = null;
        try {
            if (stringArray[0].equals("")) {
                System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "MISSING_REQUIRED_MANAGED_SYSTEM", "Missing required managed system."));
                return false;
            }
            this._managedSystem = stringArray[0].substring(stringArray[0].indexOf(34) + 1, stringArray[0].lastIndexOf(34));
            if (!stringArray[1].equals("")) {
                this._partitionName = stringArray[1].substring(stringArray[1].indexOf(34) + 1, stringArray[1].lastIndexOf(34));
            }
            this._resourceType = stringArray[2];
            if (!(this._resourceType.equalsIgnoreCase(CPU) || this._resourceType.equalsIgnoreCase(MEM) || this._resourceType.equalsIgnoreCase(SLOT))) {
                System.err.println(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_RESOURCE_TYPE", "Invalid resource type specified."));
                return false;
            }
            this._detail = Integer.parseInt(stringArray[3]) > 0;
            cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath.addKey("Name", new CIMValue((Object)this._managedSystem));
            try {
                HscUtil.getCIMInstance(this.hostName, cIMObjectPath, false);
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace(System.err);
                System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_MANAGED_SYSTEM", "Unable to find managed system {0}"), this._managedSystem));
                return false;
            }
            this._managedSystemCOP = cIMObjectPath;
            if (!this._partitionName.equals("")) {
                enumeration = HscUtil.getCIMAssociation(this.hostName, cIMObjectPath, "IBMHSC_CompSysPartition", "IBMHSC_Partition", "GroupComponent", "PartComponent");
                if (enumeration == null) {
                    System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_PARTITION_NAME", "Unable to find partition {0}"), this._partitionName));
                    return false;
                }
                while (enumeration.hasMoreElements()) {
                    cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                    cIMInstance = HscUtil.getCIMInstance(this.hostName, cIMObjectPath, false);
                    if (cIMInstance == null || (cIMProperty = cIMInstance.getProperty("UserDefinedName")) == null || !this._partitionName.equalsIgnoreCase((String)cIMProperty.getValue().getValue())) continue;
                    this._partitionCOP = cIMObjectPath;
                    string = (String)cIMInstance.getProperty("Name").getValue().getValue();
                    this._partitionSlot = new UnsignedInt8(Short.parseShort(string.substring(0, string.lastIndexOf(this._managedSystem) - 1)));
                    return true;
                }
                System.err.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "INVALID_PARTITION_NAME", "Unable to find partition {0}"), this._partitionName));
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public String getResourceType() {
        return this._resourceType;
    }

    public int printCPUInfo() {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(1);
        Vector vector2 = new Vector(5);
        UnsignedInt8[] unsignedInt8Array = new UnsignedInt8[]{};
        String string = null;
        int n = this._partitionSlot.intValue();
        try {
            vector.addElement(new CIMProperty(LPAR_SLOT_ID, new CIMValue((Object)this._partitionSlot)));
            HscUtil.invokeCIMMethod(this.hostName, this._managedSystemCOP, GET_DLPAR_CPU_INFO, vector, vector2);
            unsignedInt8Array = ((Vector)((CIMProperty)vector2.firstElement()).getValue().getValue()).toArray(unsignedInt8Array);
            if (n == 0) {
                if (this._detail) {
                    System.out.println(unsignedInt8Array[0]);
                } else {
                    System.out.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "UNALLOCATED_CPU", "{0} free CPUs in {1}"), unsignedInt8Array[0].toString(), this._managedSystem));
                }
            } else {
                short s;
                short s2;
                short s3;
                int n2;
                string = (String)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                int n3 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    if (string.charAt(n2) != '1') continue;
                    ++n3;
                }
                if (string.charAt(n2 - 1) == '0') {
                    s3 = 0;
                    s2 = 0;
                    s = 0;
                } else {
                    s = unsignedInt8Array[n3].shortValue();
                    unsignedInt8Array = ((Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).toArray(unsignedInt8Array);
                    s2 = unsignedInt8Array[n3].shortValue();
                    unsignedInt8Array = ((Vector)((CIMProperty)vector2.elementAt(2)).getValue().getValue()).toArray(unsignedInt8Array);
                    s3 = unsignedInt8Array[n3].shortValue();
                }
                if (this._detail) {
                    System.out.println(s + NO_FORMAT_DELIMITER + s2 + NO_FORMAT_DELIMITER + s3);
                } else {
                    System.out.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "ALLOCATED_CPU", "{0};{1};{2}"), Integer.toString(s), Integer.toString(s2), Integer.toString(s3)));
                }
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return 0;
        }
    }

    public int printMEMInfo() {
        Vector vector = new Vector(4);
        UnsignedInt32[] unsignedInt32Array = new UnsignedInt32[]{};
        CIMInstance cIMInstance = null;
        String string = null;
        int n = 0;
        int n2 = this._partitionSlot.intValue();
        try {
            HscUtil.invokeCIMMethod(this.hostName, this._managedSystemCOP, GET_DLPAR_MEM_INFO, new Vector(), vector);
            unsignedInt32Array = ((Vector)((CIMProperty)vector.firstElement()).getValue().getValue()).toArray(unsignedInt32Array);
            if (n2 == 0) {
                cIMInstance = HscUtil.getCIMInstance(this.hostName, this._managedSystemCOP, false);
                n = ((UnsignedInt32)cIMInstance.getProperty("LMBSize").getValue().getValue()).intValue();
                if (this._detail) {
                    System.out.println(n + NO_FORMAT_DELIMITER + unsignedInt32Array[0]);
                } else {
                    System.out.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "UNALLOCATED_MEM", "{0};{1}"), Integer.toString(n), unsignedInt32Array[0].toString()));
                }
            } else {
                int n3;
                int n4;
                int n5;
                int n6;
                string = (String)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                int n7 = 0;
                for (n6 = 0; n6 < n2; ++n6) {
                    if (string.charAt(n6) != '1') continue;
                    ++n7;
                }
                if (string.charAt(n6 - 1) == '0') {
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                } else {
                    n3 = unsignedInt32Array[n7].intValue();
                    unsignedInt32Array = ((Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue()).toArray(unsignedInt32Array);
                    n4 = unsignedInt32Array[n7].intValue();
                    unsignedInt32Array = ((Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue()).toArray(unsignedInt32Array);
                    n5 = unsignedInt32Array[n7].intValue();
                }
                if (this._detail) {
                    System.out.println(n3 + NO_FORMAT_DELIMITER + n4 + NO_FORMAT_DELIMITER + n5);
                } else {
                    System.out.println(MessageFormat.format(HSCResourceBundleUtil.getMessage("DLPARBundle", "ALLOCATED_MEM", "{0};{1};{2}"), Integer.toString(n3), Integer.toString(n4), Integer.toString(n5)));
                }
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return 0;
        }
    }

    public int printSLOTInfo() {
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable hashtable3 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        String string5 = "";
        boolean bl2 = false;
        int n = this._partitionSlot.intValue();
        CIMInstance cIMInstance = null;
        try {
            if (n == 0) {
                hashtable = (Hashtable)CECInfo.getAssignedPartitions(this.hostName, this._managedSystemCOP).get("IO");
                hashtable2 = CECInfo.getIoInfo(this.hostName, this._managedSystemCOP, hashtable);
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    hashtable = (Hashtable)hashtable2.get(string);
                    if (hashtable.containsKey("DRAWER_CIM_INSTANCE") && hashtable != null) {
                        string4 = !this._detail ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "DRAWER", "Drawer") + " : " + string : string;
                        bl = false;
                    }
                    if (hashtable == null) continue;
                    cIMInstance = null;
                    string2 = "";
                    string3 = "";
                    Enumeration enumeration2 = hashtable.keys();
                    while (enumeration2.hasMoreElements()) {
                        string = (String)enumeration2.nextElement();
                        if (string.startsWith("Group_")) {
                            string5 = !this._detail ? new String(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "IOGROUP", "I/O Group") + " : " + string) : string;
                            bl2 = false;
                            hashtable3 = (Hashtable)hashtable.get(string);
                            Enumeration enumeration3 = hashtable3.keys();
                            while (enumeration3.hasMoreElements()) {
                                string = (String)enumeration3.nextElement();
                                cIMInstance = (CIMInstance)hashtable3.get(string);
                                string2 = (String)cIMInstance.getProperty("SlotLocation").getValue().getValue();
                                string3 = (String)cIMInstance.getProperty("ClassCodeInfo").getValue().getValue();
                                if (string.indexOf(":", 0) < 0) {
                                    if (!bl && !this._detail) {
                                        System.out.println("\n" + string4);
                                        bl = true;
                                    }
                                    if (!bl2 && !this._detail) {
                                        System.out.println("\t" + string5);
                                        bl2 = true;
                                    }
                                    if (!this._detail) {
                                        System.out.println("\t\t" + string + "/" + string2 + " (" + string3 + ")");
                                    } else {
                                        System.out.print("<" + string4 + NO_FORMAT_DELIMITER + string + NO_FORMAT_DELIMITER + string2 + NO_FORMAT_DELIMITER + string3 + NO_FORMAT_DELIMITER + string5 + ">");
                                    }
                                }
                                string3 = "";
                                string2 = "";
                            }
                            string5 = "";
                            continue;
                        }
                        if (string.equals("DRAWER_CIM_INSTANCE")) continue;
                        cIMInstance = (CIMInstance)hashtable.get(string);
                        string2 = (String)cIMInstance.getProperty("SlotLocation").getValue().getValue();
                        string3 = (String)cIMInstance.getProperty("ClassCodeInfo").getValue().getValue();
                        if (string.indexOf(":", 0) < 0) {
                            if (!bl && !this._detail) {
                                System.out.println("\n" + string4);
                                bl = true;
                            }
                            if (!this._detail) {
                                System.out.println("\t\t" + string + "/" + string2 + " (" + string3 + ")");
                            } else {
                                System.out.print("<" + string4 + NO_FORMAT_DELIMITER + string + NO_FORMAT_DELIMITER + string2 + NO_FORMAT_DELIMITER + string3 + NO_FORMAT_DELIMITER + string5 + ">");
                            }
                        }
                        string3 = "";
                        string2 = "";
                    }
                }
            } else {
                hashtable2 = LPARInfo.getResourcesInfo(this.hostName, this._partitionCOP);
                if (hashtable2 != null) {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        if (string.equals("PROCESSORS") || string.equals("MEMORY")) continue;
                        string4 = !this._detail ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "DRAWER", "Drawer") + " : " + string : string;
                        bl = false;
                        hashtable = (Hashtable)hashtable2.get(string);
                        if (hashtable == null) continue;
                        Enumeration enumeration4 = hashtable.keys();
                        while (enumeration4.hasMoreElements()) {
                            string = (String)enumeration4.nextElement();
                            if (string.startsWith("Group_")) {
                                string5 = !this._detail ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "IOGROUP", "I/O Group") + " : " + string : string;
                                bl2 = false;
                                hashtable3 = (Hashtable)hashtable.get(string);
                                Enumeration enumeration5 = hashtable3.keys();
                                while (enumeration5.hasMoreElements()) {
                                    string = (String)enumeration5.nextElement();
                                    if (!bl && !this._detail) {
                                        System.out.println("\n" + string4);
                                        bl = true;
                                    }
                                    if (!bl2 && !this._detail) {
                                        System.out.println("\t" + string5);
                                        bl2 = true;
                                    }
                                    if (!this._detail) {
                                        System.out.println("\t\t" + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "IOSLOT", "I/O Slot") + " : " + string);
                                        continue;
                                    }
                                    System.out.print("<" + string4 + NO_FORMAT_DELIMITER + string + NO_FORMAT_DELIMITER + string5 + ">");
                                }
                                continue;
                            }
                            if (!bl && !this._detail) {
                                System.out.println("\n" + string4);
                                bl = true;
                            }
                            if (!this._detail) {
                                System.out.println("\t" + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "IOSLOT", "I/O Slot") + " : " + string);
                                continue;
                            }
                            System.out.print("<" + string4 + NO_FORMAT_DELIMITER + string + NO_FORMAT_DELIMITER + string5 + ">");
                        }
                    }
                }
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return 0;
        }
    }

    public static void main(String[] stringArray) {
        String string;
        int n = 0;
        LsHwRes lsHwRes = new LsHwRes();
        if (!lsHwRes.validateArguments(stringArray)) {
            System.exit(0);
        }
        n = (string = lsHwRes.getResourceType()).equalsIgnoreCase(CPU) ? lsHwRes.printCPUInfo() : (string.equalsIgnoreCase(MEM) ? lsHwRes.printMEMInfo() : lsHwRes.printSLOTInfo());
        System.exit(n);
    }
}

